/* file of general firm level characteristics for the 257 firms
interviewed under the RPED surveys; some characteristics are
time invariant (sector, location); others might change
between waves of the survey (ownership, legal status); firm size
is measured as average size over three waves; firm age is measured
as of 1999 */


libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';
libname cd4 'd:\tanz4\createdata';


/* FIRM SIZE DUMMIES */
/* ***************** */

/* firm size using average employment over period */

data firmw1; set cd.w1chars;
wave=1;


data firmw2; set cd.w2chars;
wave=2;


data firmw3; set cd.w3chars;
wave=3;


data temp1; merge firmw1 firmw2 firmw3; by firm;

if firm=43 then emp92=.;
if firm=10 then emp93=.;
if firm=10 then emp95=.;

aveemp=(emp92+emp93+emp95)/3;

if emp95=. then aveemp=(emp92+emp93)/2;
if emp92=. then aveemp=(emp93+emp95)/2;
if emp93=. then aveemp=(emp92+emp95)/2;

if emp92=. and emp95=. then aveemp=emp93;
if emp92=. and emp93=. then aveemp=emp95;
if emp93=. and emp95=. then aveemp=emp92;

if aveemp ge 1 and aveemp le 5 then avesize=1;
if aveemp ge 6 and aveemp le 29 then avesize=2;
if aveemp ge 30 and aveemp le 99 then avesize=3;
if aveemp ge 100 then avesize=4;

if avesize=1 then sizedum='amicro';
if avesize=2 then sizedum='bsmall';
if avesize=3 then sizedum='cmedium';
if avesize=4 then sizedum='dlarge';

if avesize=1 then micro=1; else micro=0;
if avesize=2 then small=1; else small=0;
if avesize=3 then medium=1; else medium=0;
if avesize=4 then large=1; else large=0;

keep firm wave emp92 emp93 emp95 size92 size93 size95
aveemp avesize sizedum micro small medium large name;

proc means; run;


/* SECTORS AND LOCATIONS */
/* ********************* */

data temp2; set tz.tz123;
options nolabel;
firm=key;
keep firm indu loca sect;


data temp3; merge temp2 tz.addvar; by firm;

/* industrial sector */
if indu=1 then secdum='afood';
if indu=2 then secdum='btext';
if indu=3 then secdum='cwood';
if indu=4 then secdum='dmetal';

if indu=1 then food=1; else food=0;
if indu=2 then text=1; else text=0;
if indu=3 then wood=1; else wood=0;
if indu=4 then metal=1; else metal=0;

/* location with code change for Iringa */
if loca=6 then loca=7;

if loca=1 then locdum='aDSM';
if loca=2 then locdum='bMOR';
if loca=3 then locdum='cTAN';
if loca=4 then locdum='dARU';
if loca=5 then locdum='eMWA';
if loca=7 then locdum='gIRI';

if locdum='aDSM' then DSM=1; else DSM=0;
if locdum='bMOR' then morog=1; else morog=0;
if locdum='cTAN' then tanga=1; else tanga=0;
if locdum='dARU' then arush=1; else arush=0;
if locdum='eMWA' then mwanz=1; else mwanz=0;
if locdum='gIRI' then iringa=1; else iringa=0;

/* disaggregated sector dummies */
if isic ge 3110 and isic le 3129 and isic ne 3117 then foodx=1;
else foodx=0;
if isic=3117 then bake=1; else bake=0;
if isic ge 3130 and isic le 3135 then bevs=1; else bevs=0;

if isic ge 3310 and isic le 3319 then woodx=1; else woodx=0;
if isic=3320 then furn=1; else furn=0;

if isic ge 3210 and isic le 3219 then textx=1; else textx=0;
if isic=3220 then garment=1; else garment=0;
if isic=3240 then shoes=1; else shoes=0;

if isic ge 3810 and isic le 3819 then metalx=1; else metalx=0;
if isic ge 3820 and isic le 3850 then machine=1; else machine=0;

if foodx=1 then dsecdum='afood';
if bake=1 then dsecdum='bbake';
if bevs=1 then dsecdum='cbevs';
if woodx=1 then dsecdum='dwood';
if furn=1 then dsecdum='efurn';
if textx=1 then dsecdum='ftext';
if garment=1 then dsecdum='ggarm';
if shoes=1 then dsecdum='hshoes';
if metalx=1 then dsecdum='imetal';
if machine=1 then dsecdum='jmach';

/* classifying firms with other isic codes */
/* leather tannery */
if firm=225 then textx=1;
if firm=225 then dsecdum='ftext';
/* tobacco firm */
if firm=422 then foodx=1;
if firm=422 then dsecdum='afood';

/* capital city dummy */
if loca=1 then capcity=1; else capcity=0;

proc means; run;


/* OWNERSHIP AND LEGAL STATUS */
/* ************************** */

data temp4; set cd.owners;

pcfor=mean(pcfor92, pcfor93);
pcunion=mean(pcuni92, pcuni93, pcuni95);
if pcunion>0 then union=1;

keep firm union pcunion union92 union93 union95
privdom privfor privdf sprivdom sprivfor sprivdf state
sstate sfor tzown anyfor anyst pcfor
solo partner lle privcorp statcorp coop subdom subfor
african asian mixed mideast other;

proc means; run;


/* FIRM AGE DUMMIES */
/* **************** */

data tempg; set cd.owner1;
keep firm styear1;

data temph; set cd.owner2;
keep firm styear2;

data age1; merge tempg temph; by firm;
yrcom=styear1;
if yrcom=. then yrcom=styear2;
keep firm yrcom;

data age2; set cd4.firmchar;
keep firm styear startup stupyear firmage;
proc means; run;

data chkage; merge age1 age2; by firm;

if styear=. then delete;
if yrcom=. then delete;
if yrcom > styear+3 or yrcom < styear-3;
proc print; var firm yrcom styear startup stupyear;
run;

data firmage; merge age1 age2; by firm;
if firm>700 then delete;

if styear=. then styear=yrcom;
if styear=. then styear=1992;

firmage=1999-styear;

if firmage>20 then old=1; else old=0;
if firmage>10 and firmage<21 then mature=1; else mature=0;
if firmage>5 and firmage<11 then young=1; else young=0;
if firmage<6 then new=1; else new=0;

if firmage>20 then agedum='aold';
if firmage>10 and firmage<21 then agedum='bmature';
if firmage>5 and firmage<11 then agedum='cyoung';
if firmage<6 then agedum='dnew';

keep firm styear firmage old mature young new agedum;
proc means; run;



/* EXPORT DUMMIES */
/* ************** */

/*  need to take account of error in wave 2 
measurement of percentage of output exported */

data export1; set cd.genfirm1;
expdum1=expdum;
pcexp92=exppc;
keep firm wave expdum expdum1 pcexp92;
proc sort; by firm;

data export2; set cd.genfirm2;
expdum2=expdum;
pcxaf93=expaf;
pcxnaf93=expnaf;
if expaf=. then expaf=0;
if expnaf=. then expnaf=0;
pcexp93=expaf+expnaf;
keep firm wave expdum expdum2 pcexp93 pcxaf93 pcxnaf93;
proc sort; by firm;

data export3; set cd.genfirm3;
expdum3=expdum;
pcexp95=pcexp;
if firm=201 then expaf=80;
if firm=201 then expnaf=20;
pcxaf95=(expaf*pcexp)/100;
pcxnaf95=(expnaf*pcexp)/100;
keep firm wave expdum expdum3 pcexp95 pcxaf95 pcxnaf95;
proc sort; by firm;


data export; merge export1 export2 export3; by firm;

if expdum1=1 or expdum2=1 or expdum3=1 then expdum=1;
else expdum=0;

if pcexp93=100 then pcexp93=pcexp92;
if firm=201 then pcexp93=50;
if firm=34 then pcexp93=25;

expduma=expdum;

keep firm expduma pcexp92 pcexp93 pcexp95 pcxnaf92 pcxnaf93
pcxnaf95;

proc means; run;


/* CREATING FILE OF MAIN FIRM CHARACTERISTICS
FOR 257 RPED FIRMS */

data cd.fchars1; merge temp1 temp3 temp4 firmage export; by firm;
proc means; run;
